# Tworzenie struktury danych do przechowywania labiryntu:
# Labirynt ten znajdziesz na stronie inventwithpython.com/examplemaze.txt; możesz go stamtąd pobrać i wkleić do swojego kodu
MAZE = """
#######################################################################
#S#                 #       # #   #     #         #     #   #         #
# ##### ######### # ### ### # # # # ### # # ##### # ### # # ##### # ###
# #   #     #     #     #   # # #   # #   # #       # # # #     # #   #
# # # ##### # ########### ### # ##### ##### ######### # # ##### ### # #
#   #     # # #     #   #   #   #         #       #   #   #   #   # # #
######### # # # ##### # ### # ########### ####### # # ##### ##### ### #
#       # # # #     # #     # #   #   #   #     # # #   #         #   #
# # ##### # # ### # # ####### # # # # # # # ##### ### ### ######### # #
# # #   # # #   # # #     #     #   #   #   #   #   #     #         # #
### # # # # ### # # ##### ####### ########### # ### # ##### ##### ### #
#   # #   # #   # #     #   #     #       #   #     # #     #     #   #
# ### ####### ##### ### ### ####### ##### # ######### ### ### ##### ###
#   #         #     #     #       #   # #   # #     #   # #   # #   # #
### ########### # ####### ####### ### # ##### # # ##### # # ### # ### #
#   #   #       # #     #   #   #     #       # # #     # # #   # #   #
# ### # # ####### # ### ##### # ####### ### ### # # ####### # # # ### #
#     #         #     #       #           #     #           # #      E#
#######################################################################
""".split('\n')

# Stałe użyte w programie:
EMPTY = ' '
START = 'S'
EXIT = 'E'
PATH = '.'

# Ustalenie wymiarów labiryntu:
HEIGHT = len(MAZE)
WIDTH = 0
for row in MAZE: # WIDTH to szerokość najszerszego wiersza
    if len(row) > WIDTH:
        WIDTH = len(row)
# Przekształcenie każdego wiersza labiryntu na listę o długości WIDTH:
for i in range(len(MAZE)):
    MAZE[i] = list(MAZE[i])
    if len(MAZE[i]) != WIDTH:
        MAZE[i] = [EMPTY] * WIDTH # Tworzenie pustego wiersza

def printMaze(maze):
    for y in range(HEIGHT):
        # Wyświetlanie wierszy.
        for x in range(WIDTH):
            # Wyświetlanie kolumn z danego wiersza
            print(maze[y][x], end='')
        print() # Dodanie znaku nowej linii na końcu wiersza
    print()

def findStart(maze):
    for x in range(WIDTH):
        for y in range(HEIGHT):
            if maze[y][x] == START:
                return (x, y) # Zwrócenie współrzędnych  początkowych

def solveMaze(maze, x=None, y=None, visited=None):
    if x == None or y == None:
        x, y = findStart(maze)
        maze[y][x] = EMPTY # Pozbycie się litery 'S' z labiryntu
    if visited == None:
        visited = [] # Tworzenie listy odwiedzonych punktów

    if maze[y][x] == EXIT:
        return True # Znaleziono wyjście, funkcja zwraca True

    maze[y][x] = PATH # Oznaczenie ścieżki w labiryncie
    visited.append(str(x) + ',' + str(y))
    #printMaze(maze) # Odkomentuj, aby zobaczyć każdy krok algorytmu

    # Odwiedzenie półśnocnego sąsiada:
    if y + 1 < HEIGHT and maze[y + 1][x] in (EMPTY, EXIT) and \
    str(x) + ',' + str(y + 1) not in visited:
        # PRZYPADEK REKURENCYJNY
        if solveMaze(maze, x, y + 1, visited):
            return True # PRZYPADEK BAZOWY
    # Odwiedzenie południowego sąsiada:
    if y - 1 >= 0 and maze[y - 1][x] in (EMPTY, EXIT) and \
    str(x) + ',' + str(y - 1) not in visited:
        # PRZYPADEK REKURENCYJNY
        if solveMaze(maze, x, y - 1, visited):
            return True # PRZYPADEK BAZOWY
    # Odwiedzenie wschodniego sąsiada:
    if x + 1 < WIDTH and maze[y][x + 1] in (EMPTY, EXIT) and \
    str(x + 1) + ',' + str(y) not in visited:
        # PRZYPADEK REKURENCYJNY
        if solveMaze(maze, x + 1, y, visited):
            return True # PRZYPADEK BAZOWY
    # Odwiedzenie zachodniego sąsiada:
    if x - 1 >= 0 and maze[y][x - 1] in (EMPTY, EXIT) and \
    str(x - 1) + ',' + str(y) not in visited:
        # PRZYPADEK REKURENCYJNY
        if solveMaze(maze, x - 1, y, visited):
            return True # PRZYPADEK BAZOWY

    maze[y][x] = EMPTY # Reset pustej przestrzeni
    #printMaze(maze) # Odkomentuj, aby zobaczyć każdy krok podczas nawracania

    return False # PRZYPADEK BAZOWY

printMaze(MAZE)
solveMaze(MAZE)
printMaze(MAZE)
